﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.InteropServices;  // wg DLLImport


namespace Stereo_DAC_PORT_DLL
{
    class Cla_SPI
    {
        [DllImport("port.dll")]
        public static extern bool OPENCOM(string A);
        [DllImport("port.dll")]
        public static extern void CLOSECOM();
        [DllImport("port.dll")]
        public static extern void DTR(int B);
        [DllImport("port.dll")]
        public static extern void RTS(int B);
        [DllImport("port.dll")]
        public static extern void TXD(int B);
        [DllImport("port.dll")]
        public static extern bool CTS();
        [DllImport("port.dll")]
        public static extern bool DSR();
        [DllImport("port.dll")]
        public static extern bool RI();
        [DllImport("port.dll")]

        public static extern bool DCD();

        // public abstrakt Cla_SPI();

        private bool b_isOpen = false;
        public bool isOpen() { return b_isOpen; }

        public bool Open(string portname, int i_baud, char c_parity, int i_data, int i_stop)
        {
            try
            { //  string scn = "COM1:115200,n,8,1";
                b_isOpen = OPENCOM(portname + ":" + i_baud.ToString() + "," + c_parity + "," + i_data.ToString() + "," + i_stop.ToString());
            }
            catch { b_isOpen = false; }
            return b_isOpen;
        }

        public bool Close() { CLOSECOM(); b_isOpen = false; return true; }

        public bool SCK(bool b) { if (b) { RTS(1); } else { RTS(0); } return DSR(); }
        public bool MOSI(bool b) { if (b) { DTR(1); } else { DTR(0); } return DCD(); }
        public bool RSTi(bool b) { if (b) { TXD(1); } else { TXD(0); } return CTS(); }
        public void MOSIw1() { MOSI(true); SCK(true); SCK(false); }
        public void MOSIw0() { MOSI(false); SCK(true); SCK(false); }
        public void MOSIw(bool b) { MOSI(b); SCK(true); SCK(false); }
        public bool MOSIin() { return DCD(); }
        public bool SCKin() { return DSR(); }
        public bool RSTiin() { return CTS(); }
        public void set_DA_L(int i_val)
        {
            RSTi(false);//     TXD(0);
            MOSIw(false); // 15=Channel=0
            MOSIw(false); // 14=Buffer=0
            MOSIw(true);  // 13=/GAIN=1=1x
            MOSIw(true);   // 12=/SHDN=1=active

            MOSIw((i_val & 0x200) > 0);
            MOSIw((i_val & 0x100) > 0);
            MOSIw((i_val & 0x080) > 0);
            MOSIw((i_val & 0x040) > 0);
            MOSIw((i_val & 0x020) > 0);
            MOSIw((i_val & 0x010) > 0);
            MOSIw((i_val & 0x008) > 0);
            MOSIw((i_val & 0x004) > 0);
            MOSIw((i_val & 0x002) > 0);
            MOSIw((i_val & 0x001) > 0);

            MOSIw(false);
            MOSIw(false);
            RSTi(true);
        }

        public void set_DA_R(int i_val)
        {
            RSTi(false);//     TXD(0);
            MOSIw(true); // 15=Channel=0
            MOSIw(false); // 14=Buffer=0
            MOSIw(true);  // 13=/GAIN=1=1x
            MOSIw(true);   // 12=/SHDN=1=active

            MOSIw((i_val & 0x200) > 0);
            MOSIw((i_val & 0x100) > 0);
            MOSIw((i_val & 0x080) > 0);
            MOSIw((i_val & 0x040) > 0);
            MOSIw((i_val & 0x020) > 0);
            MOSIw((i_val & 0x010) > 0);
            MOSIw((i_val & 0x008) > 0);
            MOSIw((i_val & 0x004) > 0);
            MOSIw((i_val & 0x002) > 0);
            MOSIw((i_val & 0x001) > 0);

            MOSIw(false);
            MOSIw(false);
            RSTi(true);
        }

    }
}
